﻿using Microsoft.AspNetCore.Http;
using Microsoft.Azure.WebJobs.Host;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace ApiHookSkeleton
{
    public class SimpleBearerAuthorizeAttribute : FunctionInvocationFilterAttribute
    {
        private readonly string _expectedToken;

        public SimpleBearerAuthorizeAttribute(string expectedToken)
        {
            _expectedToken = expectedToken;
        }

        public override async Task OnExecutingAsync(FunctionExecutingContext executingContext, CancellationToken cancellationToken)
        {
            HttpRequest request = executingContext.Arguments["req"] as HttpRequest;

            if (request.Headers.ContainsKey("Authorization"))
            {
                string token = request.Headers["Authorization"].ToString().Replace("Bearer ", string.Empty);

                if (!string.Equals(token, _expectedToken, StringComparison.Ordinal))
                {
                    throw new InvalidOperationException("Unauthorized access: Invalid token.");
                }
            }
            else
            {
                throw new InvalidOperationException("Unauthorized access: Authorization header missing.");
            }
        }
    }
}
